/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.unige.solidify.exception.SolidifyBagItCheckingException;
import ch.unige.solidify.util.BagItTool;
import ch.unige.solidify.util.FileTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"bagit-check"})
public class BagitCheck
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(BagitCheck.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;

    public void run(String ... arg0) {
        String prefix = "[BagIt Check]";
        if (!this.loadFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[BagIt Check]", (Object)this.loadFolder);
            int count = 0;
            for (Path aipFolder : FileTool.scanFolder((Path)Paths.get(this.loadFolder, new String[0]), x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                ++count;
                Instant start = Instant.now();
                try {
                    log.info("{} AIP {} check start", (Object)"[BagIt Check]", (Object)aipFolder);
                    BagItTool.check((String)"BagIt-Profile-DLCM.json", (String)aipFolder.toString());
                    log.info("{} AIP {} check successful", (Object)"[BagIt Check]", (Object)aipFolder);
                }
                catch (SolidifyBagItCheckingException e) {
                    log.error("{} AIP {} check failed:", new Object[]{"[BagIt Check]", aipFolder, e});
                }
                catch (Exception e) {
                    log.error("{} AIP {} check crashed:", new Object[]{"[BagIt Check]", aipFolder, e});
                }
                Instant finish = Instant.now();
                log.info("{} AIP {} check duration: {}s", new Object[]{"[BagIt Check]", aipFolder, Duration.between(start, finish).getSeconds()});
            }
            log.info("{} BagIt checking end {} : {} processed AIP(s)", new Object[]{"[BagIt Check]", this.loadFolder, count});
        }
    }
}

